// ------------------------------------------ USB Dll Loader
#include <ctype.h>
#include <windows.h>
#include <math.h>      
#include <string.h>
#include <TCHAR.h>
#include "DllLoader.h"
#include "USBDllLoader.h"


USBdllLoader::USBdllLoader()
{
    TCHAR szPathCu30    [MAX_PATH];
	TCHAR nameXll[] = TEXT("CU30.dll");
	TCHAR nameXl2[] = TEXT("CU30Wrap.dll");
	PTCHAR pszdest  = NULL;
    PTCHAR pszPathCu30 = szPathCu30;
	DWORD nSizePath;
    HMODULE hModuleCu30wrap = NULL ;                              //HINSTANCE
	
	hModuleCu30wrap    = GetModuleHandle(  nameXl2 );
	if (hModuleCu30wrap)
	{
	  nSizePath = GetModuleFileName( hModuleCu30wrap , szPathCu30 , MAX_PATH ) ;
	  if (nSizePath)
		{
		  pszdest =  _tcsstr( pszPathCu30,  nameXl2);
		  if (pszdest)
			{
			  ZeroMemory( pszdest , 2 ); 
			  if (lstrcat(szPathCu30,nameXll))
				{
				  LoadLibrary(szPathCu30);
				}
			}
		}
	}
  LoadLibrary(nameXll);
  #pragma warning(disable : 4996)
  
  // names of the functions are defined here 
  strcpy(ifCU30Stop.Name,"CU30PiezoStop");
  ifCU30Stop.Status = ipsUnknown; 
  ifCU30Stop.ptrToFunc = NULL; 
  strcpy(ifCU30Open.Name,"CU30Open");
  ifCU30Open.Status = ipsUnknown; 
  ifCU30Open.ptrToFunc = NULL; 
  strcpy(ifCU30Close.Name,"CU30Close");
  ifCU30Close.Status = ipsUnknown; 
  ifCU30Close.ptrToFunc = NULL; 
  strcpy(ifCU30Sweep.Name,"CU30Move");
  ifCU30Sweep.Status = ipsUnknown; 
  ifCU30Sweep.ptrToFunc = NULL; 
  strcpy(ifCU30Step.Name,"CU30Step");
  ifCU30Step.Status = ipsUnknown; 
  ifCU30Step.ptrToFunc = NULL; 
  strcpy(ifCU30DCDCon.Name,"CU30DCDCon");
  ifCU30DCDCon.Status = ipsUnknown; 
  ifCU30DCDCon.ptrToFunc = NULL; 
  strcpy(ifCU30DCDCoff.Name,"CU30DCDCoff");
  ifCU30DCDCoff.Status = ipsUnknown; 
  ifCU30DCDCoff.ptrToFunc = NULL; 
  strcpy(ifGetUSBEEPromInfo.Name,"GetUSBEEPromInfo");
  ifGetUSBEEPromInfo.Status = ipsUnknown; 
  ifGetUSBEEPromInfo.ptrToFunc = NULL; 
  strcpy(ifEcho.Name,"Echo");
  ifEcho.Status = ipsUnknown; 
  ifEcho.ptrToFunc = NULL; 
  strcpy(ifTestReady.Name,"CU30TestReady");
  ifTestReady.Status = ipsUnknown; 
  ifTestReady.ptrToFunc = NULL; 
  #pragma warning(default:4996)

  Connect();
}

USBdllLoader::~USBdllLoader()
{

}
void USBdllLoader::Connect()
{   
   // An attempt is made to find all the pre-defined entry points in the dll
   ifCU30Stop.ptrToFunc = GetProcAddress(ifCU30Stop.Name,ifCU30Stop.Status);      
   ifCU30Open.ptrToFunc = GetProcAddress(ifCU30Open.Name,ifCU30Open.Status);         

   ifCU30Close.ptrToFunc = GetProcAddress(ifCU30Close.Name,ifCU30Close.Status);         
   ifGetUSBEEPromInfo.ptrToFunc = GetProcAddress(ifGetUSBEEPromInfo.Name,ifGetUSBEEPromInfo.Status);         
   ifCU30DCDCoff.ptrToFunc = GetProcAddress(ifCU30DCDCoff.Name,ifCU30DCDCoff.Status);         
   ifCU30Sweep.ptrToFunc = GetProcAddress(ifCU30Sweep.Name,ifCU30Sweep.Status);         
   ifCU30Step.ptrToFunc = GetProcAddress(ifCU30Step.Name,ifCU30Step.Status);         
   ifCU30DCDCon.ptrToFunc = GetProcAddress(ifCU30DCDCon.Name,ifCU30DCDCon.Status);         
   ifEcho.ptrToFunc = GetProcAddress(ifEcho.Name,ifEcho.Status);         
   ifTestReady.ptrToFunc = GetProcAddress(ifTestReady.Name,ifTestReady.Status);         
}

DWORD USBdllLoader::CU30Echo(DeviceRec devRec, WORD w)
{
	if ( IsLoaded() && (ifEcho.Status==ipsAvailable))
	{
	    DWORD res = 0x00;
    res = ((pEcho)ifEcho.ptrToFunc)(devRec,w);    
    return res;      
	}
	else
		return 0x00;
}
DWORD USBdllLoader::CU30TestReady(DeviceRec devRec)
{
	if ( IsLoaded() && (ifTestReady.Status==ipsAvailable))
	{
		DWORD res = 0x00;
    res = ((pCU30TestReady)ifTestReady.ptrToFunc)(devRec);    
    return res;      
	}
	else
		return 0x00;
}	
bool USBdllLoader::CU30Stop(DeviceRec devRec)
{
	if ( IsLoaded() && (ifCU30Stop.Status==ipsAvailable))
	{
		
    ((pCU30Stop)ifCU30Stop.ptrToFunc)(devRec);    
    return true;      
	}
	else
		return false;
}	
bool USBdllLoader::CU30Open(DeviceRec * pdevRec, char ** refStr)
{
  if ( IsLoaded() && (ifCU30Open.Status==ipsAvailable))
	{
		
    ((pCU30Open)ifCU30Open.ptrToFunc)(&tempR, pdevRec);    
    * refStr = tempR.A;
    return true;      
	}
	else
		return false;
}
bool USBdllLoader::CU30Close(DeviceRec devRec)
{
  if ( IsLoaded() && (ifCU30Close.Status==ipsAvailable))
	{
		
    ((pCU30Close)ifCU30Close.ptrToFunc)(devRec);    
    return true;      
	}
	else
		return false;
}
bool USBdllLoader::CU30Sweep(DeviceRec MUSBDeviceID, int Vel, int Axis, int Timeout)
{
  if ( IsLoaded() && (ifCU30Sweep.Status==ipsAvailable))
	{
		long lSpeed = (long)Vel;
    long lAxis = (long)Axis;
    long lTimeout = (long)Timeout;
    if(lTimeout == 0)
      lTimeout = 255; // in the new version 255 means infinite timeout 20.07.05, the allowed values are 2..255
    ((pCU30Sweep)ifCU30Sweep.ptrToFunc)(MUSBDeviceID,lAxis,lSpeed,lTimeout);    
    return true;      
	}
	else
		return false;
}
bool USBdllLoader::CU30Step(DeviceRec MUSBDeviceID, int Axis, int n, int Vel)
{
  if ( IsLoaded() && (ifCU30Step.Status==ipsAvailable))
	{
		long lSpeed = (long)Vel;
    long lAxis = (long)Axis;
    long lSteps = (long)n; 
    if(lSteps<0)
    {
      // in the new version the sign is coded in speed, not in the steps (20.07.05)
      lSteps = -lSteps;
      lSpeed = -lSpeed;
    }   
    ((pCU30Step)ifCU30Step.ptrToFunc)(MUSBDeviceID,lAxis,lSpeed,lSteps);    
    return true;      
	}
	else
		return false;
}
bool USBdllLoader::CU30DCDCon(DeviceRec devRec)
{
  if ( IsLoaded() && (ifCU30DCDCon.Status==ipsAvailable))
	{
		
    ((pCU30DCDCon)ifCU30DCDCon.ptrToFunc)(devRec);    
    return true;      
	}
	else
		return false;
}
bool USBdllLoader::CU30DCDCoff(DeviceRec devRec)
{
  if ( IsLoaded() && (ifCU30DCDCoff.Status==ipsAvailable))
	{
		
    ((pCU30DCDCoff)ifCU30DCDCoff.ptrToFunc)(devRec);    
    return true;      
	}
	else
		return false;
}
USBEEProm USBdllLoader::GetUSBEEPromInfo(DeviceRec devRec)
{
  USBEEProm usbEEprom;
  usbEEprom.Company[0] = '\0';
  usbEEprom.EEPromID = 0;
  usbEEprom.DeviceID = 0;
  usbEEprom.SerialNumber = 0;
  usbEEprom.ProductStr[0] = '\0';
  usbEEprom.Date[0] = '\0';
  usbEEprom.Customer[0] = '\0';
  int r = sizeof(DWORD);
  int e = sizeof(USBEEProm);
  if ( IsLoaded() && (ifGetUSBEEPromInfo.Status==ipsAvailable))
	{
		
    ((pGetUSBEEPromInfo)ifGetUSBEEPromInfo.ptrToFunc)(&usbEEprom, devRec);    
    return usbEEprom;      
	}
	else
		return usbEEprom;

}
